<?php

namespace App\Services;

use App\Facades\ExceptionLog;
use App\Models\BuyboxReport;
use App\Models\Item;
use App\Models\ItemActivity;
use App\Models\RepriceSetting;
use App\Models\Order;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;
use Exception;
use stdClass;
use App\Models\BuyBoxNotification;
use App\Models\RepricingHistory;
use App\Models\WinLostPrices;
use App\Services\DataProviderService;
use Symfony\Component\Process\Pipes\WindowsPipes;
use Illuminate\Support\Facades\App;

class RepriceService
{
    /*
    itemActivities.Status
    0 or Null - in progress
    1 - completed
    2 - scrap error
    3 - verification
    4 - timeout error
    */
    public $item;
    public $offersCount;
    public $offers;
    public $min;
    public $max;
    public $bbWon;
    private $itemData;
    private $bbFeed;
    private $bbWonFromFeed;
    private $scrappedData;
    private $itemRule;
    private $lastItemActivity;
    private $bbWinnerPrice;
    private $bbWinnerSpeed;
    private $bbWinnerPro;
    private $newPrice;
    private $bbWonOld;
    private $lastState;
    private $secondaryOfferPrice;
    private $secondaryOfferSpeed;
    private $secondaryOfferPro;
    private $nearBelowCompPro;
    private $currentItemPrice;
    private $currentItemSpeed;
    private $currentItemPro;
    private $nearBelowCompPrice;
    private $nearBelowCompSpeed;
    private $increment;
    private $percentDiff;
    private $abs;
    private $percent;
    private $high;
    private $low;
    private $rule;
    private $ruleText;
    private $ruleTextBandsOn;
    private $hiFromLost;
    private $cancelled;
    private $ruleType;
    private $compShipType;
    private $low_reg;
    private $low_wfs;
    private $low_2d;
    private $low_walmart;
    private $hi_reg;
    private $hi_wfs;
    private $hi_2d;
    private $hi_walmart;
    private $compPrice;
    private $compSpeed;
    private $itemActivityId;
    private $bbWin;
    private $ruleItem;
    private $pause_reprice;
    private $next_reprice;
    private $incrementWin;
    private $incrementLost;
    private $additionalRuleText;
    private $winPrice;
    private $lostPrice;
    private $bbWinOld;
    private $itemActivity;
    private $lastItemActivities;
    private $winLostPrice;
    private $sellerDisplayName;
    private $nextReprice;


    public function __construct($item, $scrappedData = null, $bbNotification = null)
    {
        try {
            dd($scrappedData);
            $dp = new DataProviderService($item, $scrappedData, $bbNotification);
            $this->import($dp);

        } catch (Exception $e) {
            ExceptionLog::add($e, $this);
            if (App::environment('local')) { dump('Line: ' . $e->getLine() . '\r\n' . 'File: ' . $e->getFile() . '\r\n' . 'Message: ' . $e->getMessage() . '\r\n'); }

            return false;
        }
    }

    public function import($dp)
    {
        foreach (get_object_vars($dp) as $key => $value) {
            $this->$key = $value;
        }
    }

    public function getLastBestBBPrice()
    {
        try{
            $priceHistory = ItemActivity::  where('item_id', $this->item->id)
                                            ->where('bbWin', true)
                                            ->where('skip', 0)
                                            ->where('skip_hi_lo',0)
                                            ->select('id', 'buybox_price')
                                            ->orderBy('buybox_price','desc')
                                            ->limit(3)
                                            ->first();

            return $priceHistory->buybox_price;
        } catch (Exception $e) {
            ExceptionLog::add($e, $this);
            if (App::environment('local')) { dump('Line: ' . $e->getLine() . '\r\n' . 'File: ' . $e->getFile() . '\r\n' . 'Message: ' . $e->getMessage() . '\r\n'); }

            return false;
        }
    }

    public function runReprice($itemActivityId, $activityType)
    {
        try {

            $this->itemActivity = $itemActivityId;
            $this->checkFirstReprice();

            if ($this->repriceVerify()) {
                if (!$this->itemData) {
                    $this->itemActivity->description = 'Unsuccessful scrapping. Next try after 5-10 minutes. Changing Proxy...';
                    $this->itemActivity->status = 2;
                    $this->itemActivity->save();

                    return false;
                }
            } else {
                if (($this->item->published_status == 'SYSTEM_PROBLEM') && ($this->item->force_repricing)){
                    $this->itemActivity->description = $this->ruleText;
                    $this->itemActivity->status = 1;
                    $this->itemActivity->skip = 1;
                    $this->itemActivity->save();
                    return false;
                }
            }

            if (!empty($this->itemData->availabilityStatus)) {
                if ($this->itemData->availabilityStatus == 'OUT_OF_STOCK') {
                    $this->itemActivity->description = 'Unsuccessful reprice. The item OUT OF STOCK. ';
                    $this->itemActivity->status = 2;
                    $this->itemActivity->save();

                    //$this->item->is_repricing = 0;
                    $this->item->qty = 0;
                    $this->item->save();

                    return false;
                }
            }

            if (!$this->itemData->sellerDisplayName) {
                $this->itemActivity->description = 'Unsuccessful scrapping. Next try after 5-10 minutes. Changing Proxy...';
                $this->itemActivity->status = 2;
                $this->itemActivity->save();

                return false;
            }

            if (!$this->offers) {
                $this->itemActivity->description = 'Unsuccessful scrapping offers. Next try after 5-10 minutes. Changing Proxy...';
                $this->itemActivity->status = 2;
                $this->itemActivity->save();

                return false;
            }

            if (!empty($this->lastItemActivity->pause_reprice)) {
                if ((new Carbon($this->lastItemActivity->pause_reprice))->addHours(30)->gt(now())) {
                    if (($this->compShipType == $this->lastItemActivity->comp_ship_type)
                    && ($this->compPrice == $this->lastItemActivity->comp_price)) {
                        unset($this->lastItemActivity->id);
                        unset($this->lastItemActivity->created_at);
                        unset($this->lastItemActivity->updated_at);
                        unset($this->lastItemActivity->id);

                        $this->itemActivity = $this->lastItemActivity;
                        $this->itemActivity->description = 'Reprice skipped. Competion price and speed not changed. Next check in 1h.';
                        $this->itemActivity->status = 1;
                        $this->itemActivity->pause_reprice = $this->lastItemActivity->pause_reprice;
                        $this->itemActivity->next_reprice = date("Y-m-d H:i:s", strtotime('+1 hours'));
                        $this->itemActivity->save();

                        return false;
                    } else {
                        $this->itemActivity->description .= 'Reprice continued...';
                        $this->itemActivity->save();
                    }
                }
            }

            if($this->high == $this->low){
                    ItemActivity::  where('item_id', $this->item->id)->
                                    where('high', $this->high)->
                                    update(['skip' => 1]);
                    $this->hiAndLow();
                    $this->ruleText = 'Hi and Low is equal to each other and will be dropped. Appling no history rule. ';
                    $this->lastState = 'noHistory';
                    $this->winLostPrice->hbbwp_current = $this->winLostPrice->lbblp_current = null;
                    $this->winLostPrice->save();
            }

            if(($this->high == -999.12345678) || ($this->low == -999.12345678)){
                $this->ruleText = 'No history rule applied. Hi or Low undefined. ';
                $this->lastState = 'noHistory';
            }

            if ($activityType == 'startReprice') {
                if (!self::repriceDelay($this->item)) {
                    if ($this->repriceVerify()) {
                        if (!$this->hasCompetitions()) { //checked good
                            $this->repriceHasNoCompetitions();
                        } else {
                            if ($this->lastState != 'noHistory') {
                                $this->getWinLostPrice();
                            }

                            if ($this->lastState == 'lostAfterLost') {
                                if ($this->high != -999.12345678){
                                    $this->lostAfterLost();
                                } else {
                                    $this->resultNoHistory();
                                }
                            }

                            if ($this->lastState == 'noHistory') {
                                $this->resultNoHistory();
                            }

                            if ($this->lastState == 'wonAfterWin') {
                                $this->wonAfterWin();
                            }

                            if ($this->lastState == 'wonAfterLost') {
                                $this->wonAfterLost();
                            }

                            if ($this->lastState == 'lostAfterWin') {
                                if ($this->lastItemActivity->rule) {
                                    $this->lostAfterWin();
                                }
                            }
                        }

                        return $this->updateItemActivity($this->cancelled, $this->ruleText, $this->rule);
                    }
                } else {
                    //$itemActivity = ItemActivity::find($this->lastItemActivity->id);
                    if (strpos($this->lastItemActivity->description, 'The repricing is paused on 1h.<br>') === false) {
                        $this->lastItemActivity->description = 'The repricing is paused on 1h.<br>' . $this->lastItemActivity->description;
                        $this->lastItemActivity->save();
                    }
                }
            } elseif ($activityType == 'manualReprice') {
                $this->updateManual();
            } elseif ($activityType == 'updateReprice') {
                $this->updateActivity();
            }

            return false;
        } catch (Exception $e) {
            ExceptionLog::add($e, $this);
            if (App::environment('local')) { dump('Line: ' . $e->getLine() . '\r\n' . 'File: ' . $e->getFile() . '\r\n' . 'Message: ' . $e->getMessage() . '\r\n'); }

            return false;
        }
    }

    //********************** REPRICE RULES ****************************//

    private function checkFirstReprice()
    {
        $countOfItemActivities = ItemActivity::where('item_id', $this->item->id)
                                        ->where(function ($q) {
                                            $q->where('status', 1)
                                            ->orWhere('status', 3)
                                            ->orWhere('status', 0);
                                        })
                                        ->count();

        if($countOfItemActivities == 1){

            $this->itemActivity->bbWin_old = $this->bbWin;
            $this->itemActivity->high = $this->high;
            $this->itemActivity->low = $this->low;
            $this->itemActivity->save();
            $this->itemActivity->refresh();

            if(isset($this->winLostPrice)){
                $this->winLostPrice->bb_win_old = $this->bbWin;

                if ($this->bbWin){
                    $this->winLostPrice->hbbwp_current = $this->high;
                    $this->winLostPrice->win_current = $this->currentItemPrice;
                } else {
                    $this->winLostPrice->lbblp_current = $this->low;
                    $this->winLostPrice->lost_current = $this->currentItemPrice;
                }

                $this->winLostPrice->save();
            } else {
                $this->winLostPrice = new WinLostPrices();
                $this->winLostPrice->item_id = $this->item->id;
                $this->winLostPrice->bb_win_old = $this->bbWin;

                if ($this->bbWin){
                    $this->winLostPrice->hbbwp_current = $this->high;
                    $this->winLostPrice->win_current = $this->currentItemPrice;
                } else {
                    $this->winLostPrice->lbblp_current = $this->low;
                    $this->winLostPrice->lost_current = $this->currentItemPrice;
                }

                $this->winLostPrice->save();
            }
        }
    }

    private function lostAfterLost() //correct formula
    {
        try {
            if (($this->getBBLostInstanses()) && ($this->high)) { //2-2-2
            //if (($this->high) && ($this->high != -999.12345678)) { //2-2-2
                $this->rule_2_2_2();
            } elseif ($this->getBBWonCount() == 0) { // this need to check
                $this->newPrice = $this->currentItemPrice - $this->currentItemPrice * 0.005;
                $this->ruleText .=  'Rule 2-9: Don\'t have any Hi info (BBox count = 0). The price go down on 0.5%.  newPrice = currPrice - currPrice x 0.5%. ($' .
                                    round($this->newPrice, 2) . ' = $' . $this->currentItemPrice . ' - $' .
                                    $this->currentItemPrice . ' x 0.5%)';
                $this->rule = '2-9';
            } else {
                $this->hiFromLost = ($this->currentItemPrice - $this->bbWinnerPrice) / $this->bbWinnerPrice;
                $hiFromLost = "HiFromLost = $this->hiFromLost = ($$this->currentItemPrice - $$this->bbWinnerPrice) / $$this->bbWinnerPrice <br>";

                if ($this->high) {
                    if ($this->high == 0){
                        $relation = 0;
                    } else {
                        $relation = ($this->hiFromLost - $this->high) / $this->high;
                    }

                     //ERROR HAPPENED
                    $relationText = "Relation between Hi and Hi from Lost $relation = ($this->hiFromLost - $this->high) / $this->high <br>";

                    if (($relation > 0.015) && ($this->bbWinnerPrice > $this->currentItemPrice)) {
                        //use 0.5%
                        $this->newPrice = $this->bbWinnerPrice + $this->bbWinnerPrice * $this->hiFromLost;
                        $this->ruleText .= $hiFromLost;
                        $this->ruleText .= $relationText;

                        $this->ruleText .=  'Rule 2-9: Has Hi and Hi from lost, the relation is greater 0.015. bbWinnerPrice + bbWinnerPrice * hiFromLost. ($' .
                                            round($this->newPrice, 2) . ' = $' . $this->bbWinnerPrice . ' + $' .
                                            $this->bbWinnerPrice . ' x ' . $this->hiFromLost . ')';
                        $this->rule = '2-9';
                    } elseif (($relation > 0.015) && ($this->bbWinnerPrice <= $this->currentItemPrice)) {
                        $this->newPrice = $this->currentItemPrice - $this->currentItemPrice * 0.01;
                        $this->ruleText .= $hiFromLost;
                        $this->ruleText .= $relationText;
                        $this->ruleText .=  'Rule 2-9: Has Hi and Hi from lost, the difference is greater 0.015, but item price is bigger BB Price. Using rule percent 1%. currentItemPrice - currentItemPrice * percent. ($' .
                                            round($this->newPrice, 2) . ' = $' . $this->currentItemPrice . ' - $' .
                                            $this->currentItemPrice . ' x 1%)';
                        $this->rule = '2-9';
                    } else {
                        $this->newPrice = $this->currentItemPrice - $this->currentItemPrice * 0.01;
                        $this->ruleText .=  'Rule 2-9: Has Hi and Hi from lost, the difference is less 0.015. Using rule percent 1%. currentItemPrice - currentItemPrice * percent. ($' .
                                            round($this->newPrice, 2) . ' = $' . $this->currentItemPrice . ' - $' .
                                            $this->currentItemPrice . ' x 1%)';
                        $this->rule = '2-9';
                    }
                } else {
                    $this->newPrice = $this->currentItemPrice - $this->currentItemPrice * 0.01;
                    $this->ruleText .=  'Rule 2-9: Don\'t have any Hi info. The price go down on 1%.  newPrice = currPrice - currPrice x 1%. ($' .
                                        round($this->newPrice, 2) . ' = $' . $this->currentItemPrice . ' - $' .
                                        $this->currentItemPrice . ' x 1%)';
                    $this->rule = '2-9';
                }
            }

            $this->ruleType = 'lostAfterLost';
        } catch (Exception $e) {
            ExceptionLog::add($e, $this);
            if (App::environment('local')) { dump('Line: ' . $e->getLine() . '\r\n' . 'File: ' . $e->getFile() . '\r\n' . 'Message: ' . $e->getMessage() . '\r\n'); }

            return false;
        }
    }

    private function getBblostCount()
    {
        try {
            $bbLostInstances = ItemActivity::where('item_id', $this->item->id)->
                                            //where('cancelled', 0)->
                                            where('status', 1)->
                                            where('bbWin', 0)->
                                            select('id')->
                                            count();

            if ($bbLostInstances) {
                return $bbLostInstances;
            }
        } catch (Exception $e) {
            ExceptionLog::add($e, $this);
            if (App::environment('local')) { dump('Line: ' . $e->getLine() . '\r\n' . 'File: ' . $e->getFile() . '\r\n' . 'Message: ' . $e->getMessage() . '\r\n'); }

            return 0;
        }
    }

    private function getBBLostInstanses() //verified
    {
        try {
            $bbLostInstanses = ItemActivity::select('id', 'bbWin')->where('item_id', $this->item->id)->
                                            where('status', 1)->
                                            where('skip', 0)->
                                            orderBy('id', 'desc')->
                                            limit(3)->
                                            get();

            foreach ($bbLostInstanses as $bbLostInstance) {
                if ($bbLostInstance->bbWin != 0){
                    return false;
                }

                return true;
            }

        } catch (Exception $e) {
            ExceptionLog::add($e, $this);
            if (App::environment('local')) { dump('Line: ' . $e->getLine() . '\r\n' . 'File: ' . $e->getFile() . '\r\n' . 'Message: ' . $e->getMessage() . '\r\n'); }

            return false;
        }
    }

    private function getBBWonCount() //need verify
    {
        try {
            $bbWonInstances = ItemActivity::where('item_id', $this->item->id)->
                                            //where('cancelled', 0)->
                                            where('status', 1)->
                                            where('bbWin', 1)->
                                            orderBy('id', 'desc')->
                                            select('id')->
                                            count();

            return $bbWonInstances;
        } catch (Exception $e) {
            ExceptionLog::add($e, $this);
            if (App::environment('local')) { dump('Line: ' . $e->getLine() . '\r\n' . 'File: ' . $e->getFile() . '\r\n' . 'Message: ' . $e->getMessage() . '\r\n'); }

            return false;
        }
    }

    private function getLastBbWinActivity()
    {
        $ativity = ItemActivity::   where('item_id', $this->item->id)->
                                    where('status','1')->
                                    where('bbWin', 1)->
                                    where('created_at', '>', Carbon::now()->subHours(8))->
                                    select('id')->
                                    //where('skip', 0)->
                                    count();

        return ($ativity >= 1) ? true : false;
    }

    private function lostAfterWin()
    {
        try {
            $this->cleanHiAndLow();

            if ($this->getLastBbWinActivity()) {
                $this->getCompetitionsForBbLost();

                if ($this->high > $this->low) {
                    $this->rule_2_3();
                } else {

                    if (($this->compShipType == $this->lastItemActivity->comp_ship_type)
                    && ($this->compPrice == $this->lastItemActivity->comp_price)) {
                        $this->rule_2_1();
                    } elseif ($this->compShipType == $this->lastItemActivity->comp_ship_type) {
                        $this->rule_2_2();
                    } elseif ($this->compPrice == $this->lastItemActivity->comp_price){// rule 2-5
                        $this->rule_2_2();
                        $this->ruleText .=  'Original Rule 2-5: if buy box winner is diffrent shipping methood and same previous price. ';
                    } else {
                        $this->rule_2_2();
                        $this->ruleText .=  'Original Rule 2-6: if buy box winner is diffrent shipping methood and different price';
                    }
                }

            } else {
                $itemsHi = ItemActivity::where('item_id', $this->item->id)
                    ->where('bbWin', true)
                    ->where('created_at', '>', Carbon::now()->subHours(8))
                    ->select('id', 'high')
                    ->get();

                $itemsHiArr =  $itemsHi->toArray();
                $high = max(array_column($itemsHiArr, 'high'));
                $this->newPrice = $this->bbWinnerPrice + $this->bbWinnerPrice * $high;
                $this->ruleText .=  'Trying to beat comp with latest Hi (rollback win price with max hi). newPrice = compPrice + compPrice x Hi). ($' .
                                    round($this->newPrice, 2) . ' = $' . $this->bbWinnerPrice . ' - $' .
                                    $this->bbWinnerPrice . ' x ' . $high . ')';
                $this->rule = 'Exception of Rule 2';
                $this->high = $high;
            }

            $this->ruleType = 'lostAfterWin';
        } catch (Exception $e) {
            ExceptionLog::add($e, $this);
            if (App::environment('local')) { dump('Line: ' . $e->getLine() . '\r\n' . 'File: ' . $e->getFile() . '\r\n' . 'Message: ' . $e->getMessage() . '\r\n'); }

            return false;
        }
    }

    private function skipHiAndLow()
    {
        /*ItemActivity::  where('item_id', $this->lastItemActivity->item_id)->
                        update(['skip' => 1]);*/

        $this->itemActivity->skip = 1;
        $this->itemActivity->save();
        $this->itemActivity->refresh();
    }

    private function wonAfterLost()
    {
        try {
            $this->getCompetitionsForBbWin();
            $this->cleanHiAndLow();

            if (($this->high > $this->low) && ($this->low <> 999.12345678) && ($this->high != null)) { //3-3
                $this->rule_3_3();
                $this->skipHiAndLow();
            } else {
                if (($this->compShipType == $this->lastItemActivity->comp_ship_type)
                && ($this->compPrice == $this->lastItemActivity->comp_price)) { //3-1
                    $this->rule_3_1();
                } elseif (($this->compShipType == $this->lastItemActivity->comp_ship_type)) { //3-2
                    $this->rule_3_2();
                }

            }

            $this->ruleType = 'wonAfterLost';
        } catch (Exception $e) {
            ExceptionLog::add($e, $this);
            if (App::environment('local')) { dump('Line: ' . $e->getLine() . '\r\n' . 'File: ' . $e->getFile() . '\r\n' . 'Message: ' . $e->getMessage() . '\r\n'); }

            return false;
        }
    }

    private function wonAfterWin()
    {
        try {
            if ((($this->getBBWonCount() > 2) && ($this->getBblostCount() == 0))
            && (abs($this->winPrice - $this->lostPrice) > 0.02)
            ) {
                if ($this->low != 9999.12345678) {
                    $this->rule_3_5();
                } else {
                    $this->resultNoHistory();
                }

            } elseif ($this->lastItemActivity->pause_reprice != null ){
                $this->rule_3_4();
            } else {
                $this->wonAfterLost();
            }
        } catch (Exception $e) {
            ExceptionLog::add($e, $this);
            if (App::environment('local')) { dump('Line: ' . $e->getLine() . '\r\n' . 'File: ' . $e->getFile() . '\r\n' . 'Message: ' . $e->getMessage() . '\r\n'); }

            return false;
        }
    }

    private function repriceHasNoCompetitions() // General rules if no comp http://prntscr.com/Tp71DoCndeCR
    {
        try {
            if ($this->itemRule) {
                $this->ruleItem = $this->readRuleProperty('repriceRules.general.ifNoCompetition', $this->itemRule);
            } else { //read default rule
                $this->ruleItem = config('constants.repriceRules.general.ifNoCompetition');
            }

            $this->ruleItem = config('constants.repriceRules.general.ifNoCompetition');

            if ($this->ruleItem == 'useMaxPrice') {
                $this->newPrice = $this->max;
                $this->rule = 'noCompetitions.useMaxPrice';
                $this->ruleText .= 'No competitions. Going to MAX price.';
                $this->ruleType = 'noCompetitions';
            } elseif ($this->ruleItem == 'useMinPrice') {
                $this->newPrice = $this->min;
                $this->rule = 'noCompetitions.useMinPrice';
                $this->ruleText .= 'No competitions. Going to min price.';
                $this->ruleType = 'noCompetitions';
            } elseif ($this->ruleItem == 'doNothing') {
                $this->newPrice = $this->currentItemPrice;
                $this->rule = 'noCompetitions.doNothing';
                $this->ruleText .= 'No competitions. Do nothing.';
                $this->ruleType = 'noCompetitions';
            } elseif ($this->ruleItem == 'useVelocityRule') {
                $this->velocityRule();
                $this->ruleType = 'velocityRule';
            }
        } catch (Exception $e) {
            ExceptionLog::add($e, $this);
            if (App::environment('local')) { dump('Line: ' . $e->getLine() . '\r\n' . 'File: ' . $e->getFile() . '\r\n' . 'Message: ' . $e->getMessage() . '\r\n'); }

            return false;
        }
    }

    private function resultNoHistory()
    {
        try {
            if ($this->itemRule) {
                $rule = $this->readRuleProperty('repriceRules.noHistory', $this->itemRule);
            } else { //read default rule
                $rule = config('constants.repriceRules.noHistory');
            }

            $rule = config('constants.repriceRules.noHistory'); //temp to delete
            $this->ruleText .= $this->additionalRuleText ? $this->additionalRuleText : '';
            if ($this->bbWin == 1) { // bbwin
                $conditionRule = $this->readRuleProperty('bbWon.bandsON.isOn', $rule);

                if ($conditionRule) {
                    $rules = $rule['bbWon']['bandsON'];
                    unset($rules['isOn']);
                    $rule = $this->defineNoHistoryBandsOnRule($rules);
                    $this->newPrice = round($this->currentItemPrice * (100 + (float)$rule['action']['value']) / 100, 2);
                    $rulePercent = (float)$rule['action']['value'];
                    $this->ruleText .=  'No history. Applied BandsOn Rule, change price on ' . $rule['action']['value'] . $rule['action']['type'];
                    $this->ruleText .= $this->ruleTextBandsOn;
                    $this->ruleText .= "<br>$$this->newPrice = $$this->currentItemPrice * (100% + $rulePercent%)";
                    $this->rule = '1. BandsON';
                } else {
                    $rule = $rule['bbWon']['bandsOFF'];

                    if ($this->hasCompetitions()) { //1.4
                        if ($rule['1.4']['goToMin']) {
                            $this->newPrice = $this->min;
                            $this->ruleText .=  'No history. Applied BandsOFF Rule 1.4, change price to min price.';
                        } elseif ($rule['1.4']['goToMax']) {
                            $this->newPrice = $this->max;
                            $this->ruleText .=  'No history. Applied BandsOFF Rule 1.4, change price to Max price.';
                        } elseif ($rule['1.4']['goUpWithPercent']) {
                            $this->newPrice = $this->currentItemPrice * (100 + (float)$rule['1.4']['goUpWithPercent']['value']) / 100;
                            $this->ruleText .=  'No history. Applied BandsOFF Rule 1.4, go up with ' . $rule['1.4']['goUpWithPercent']['value'] . '%';
                        }

                        $this->rule = 'Rule: 1.4';
                    } elseif ($this->currentItemPrice > $this->secondaryOfferPrice) { //1.5
                        if ($rule['1.5']['match']) {
                            $this->newPrice = $this->secondaryOfferPrice;
                            $this->ruleText .=  'No history. Applied BandsOFF Rule 1.5, match price';
                        } else {
                            $this->newPrice = $this->currentItemPrice * (100 + (float)$rule['1.5']['goUpWithPercent']['value']) / 100;
                            $this->ruleText .=  'No history. Applied BandsOFF Rule 1.5, go up with ' . $rule['1.5']['goUpWithPercent']['value'] . '%';
                        }

                        $this->rule = 'Rule: 1.5';
                    } elseif ($this->currentItemPrice < $this->secondaryOfferPrice) { //1.7
                        $this->newPrice = $this->currentItemPrice * (100 + (float)$rule['1.7']['value']) / 100;
                        $this->ruleText .=  'No history. Applied BandsOFF Rule 1.7, change price on ' . $rule['1.7']['value'] . '%';
                        $this->rule = 'Rule: 1.7';
                    } elseif ($this->currentItemPrice == $this->secondaryOfferPrice) { //1.8
                        $this->newPrice = $this->currentItemPrice * (100 + (float)$rule['1.8']['value']) / 100;
                        $this->ruleText .=  'No history. Applied BandsOFF Rule 1.8, change price on ' . $rule['1.8']['value'] . '%';
                        $this->rule = 'Rule: 1.8';
                    }
                    //1.6 left very rare case
                }
            } elseif ($this->bbWin == 0) { // bblost
                $conditionRule = $this->readRuleProperty('bbLost.bandsON.isOn', $rule);

                if ($conditionRule) {
                    $rules = $rule['bbLost']['bandsON'];
                    unset($rules['isOn']);
                    $rule = $this->defineNoHistoryBandsOnRule($rules);

                    if ($rule) {
                        $rulePercent = (float)$rule['action']['value'];
                        $this->newPrice = round($this->currentItemPrice * (100 + (float)$rule['action']['value']) / 100, 2);
                        $this->ruleText .=  'No history. Applied BandsOn Rule, change price on ' . $rule['action']['value'] . $rule['action']['type'];
                        $this->ruleText .= $this->ruleTextBandsOn;
                        $this->ruleText .= "<br>$$this->newPrice = $$this->currentItemPrice * (100% + $rulePercent%)";
                    } else {
                        $this->newPrice = round($this->currentItemPrice * 0.99, 2);
                        $this->ruleText .=  'No history. Applied BandsOn Rule. The rule for such case not found. Go down on 1%';
                    }

                    $this->rule = '1. BandsON';
                } else {
                    $rule = $rule['bbLost']['bandsOFF'];

                    if ($this->lastItemActivity) { //Rule 1.2
                        $rule = $rule['1.2'];

                        if ($rule['priceIsBelow']) {
                            if ($rule['type'] == '%') {
                                $this->newPrice = $this->currentItemPrice * (100 - (float)$rule['value']) / 100;
                                $this->ruleText .=  'No history. Applied BandsON Rule 1.2, change price on ' . $rule['value'] . '%';
                            } else {
                                $this->newPrice = $this->currentItemPrice - (float)$rule['value'];
                                $this->ruleText .=  'No history. Applied BandsON Rule 1.2, change price on ' . $rule['value'] . '$';
                            }
                        } elseif ($rule['priceIsAbove']) {
                            if ($rule['type'] == '%') {
                                $this->newPrice = $this->currentItemPrice * (100 + (float)$rule['value']) / 100;
                                $this->ruleText .=  'No history. Applied BandsON Rule 1.2, change price on ' . $rule['value'] . '%';
                            } else {
                                $this->newPrice = $this->currentItemPrice + (float)$rule['value'];
                                $this->ruleText .=  'No history. Applied BandsON Rule 1.2, change price on ' . $rule['value'] . '$';
                            }
                        }

                        $this->rule = 'Rule: 1.2';
                    } else { //Rule 1.1
                        $rule = $rule['1.1'];

                        if ($rule['priceIsBelow']) {
                            if ($rule['type'] == '%') {
                                $this->newPrice = $this->currentItemPrice * (100 - (float)$rule['value']) / 100;
                            } else {
                                $this->newPrice = $this->currentItemPrice - (float)$rule['value'];
                            }
                        } elseif ($rule['priceIsAbove']) {
                            if ($rule['type'] == '%') {
                                $this->newPrice = $this->currentItemPrice * (100 + (float)$rule['value']) / 100;
                            } else {
                                $this->newPrice = $this->currentItemPrice + (float)$rule['value'];
                            }
                        }

                        $this->rule = 'Rule: 1.1';
                    }
                    //Rule 1.3
                }
            }

            $this->ruleType = 'noHistory';
        } catch (Exception $e) {
            ExceptionLog::add($e, $this);
            if (App::environment('local')) { dump('Line: ' . $e->getLine() . '\r\n' . 'File: ' . $e->getFile() . '\r\n' . 'Message: ' . $e->getMessage() . '\r\n'); }

            return false;
        }
    }

    private function velocityRule()
    {
        try {
            $this->ruleItem = config('constants.repriceRules.velocity');

            if (!$this->rule['isOn']) {
                return false;
            }

            $salesUnderPeriod = $this->ruleItem['isUnder']['salesPeriod'];
            $salesAbovePeriod = $this->ruleItem['isAbove']['salesPeriod'];
            $salesUnderCount = $this->ruleItem['isUnder']['salesCount'];
            $salesAboveCount = $this->ruleItem['isAbove']['salesCount'];

            $salesUnderDB = DB::table('orders')->
                            selectRaw('count(orders.id) as count')->
                            where('walmart_key_id', $this->item->walmart_key_id)->
                            where('order_date', '>=', date('Y-m-d h:m:s', strtotime('-' . $salesUnderPeriod . ' days')))->
                            where('sku', $this->item->sku)->
                            where('status', '<>', 'Cancelled')->
                            get();

            $salesAboveDB = DB::table('orders')->
                            selectRaw('count(orders.id) as count')->
                            where('walmart_key_id', $this->item->walmart_key_id)->
                            where('order_date', '>=', date('Y-m-d h:m:s', strtotime('-' . $salesAbovePeriod . ' days')))->
                            where('sku', $this->item->sku)->
                            where('status', '<>', 'Cancelled')->
                            get();


            if ($salesUnderCount > $salesUnderDB[0]->count) {
                if ($this->ruleItem['isUnder']['type'] == '%') {
                    $this->newPrice = $this->currentItemPrice * (100 - abs($this->ruleItem['isUnder']['value'])) / 100;
                    $this->ruleText .=  '';
                    $this->rule = '';
                } else {
                    $this->newPrice = $this->currentItemPrice - abs($this->ruleItem['isUnder']['value']);
                    $this->ruleText .=  '';
                    $this->rule = '';
                }
            }

            if ($salesAboveCount <= $salesAboveDB[0]->count) {
                if ($this->ruleItem['isAbove']['type'] == '%') {
                    $this->newPrice = $this->currentItemPrice * (100 + abs($this->ruleItem['isUnder']['value'])) / 100;
                    $this->ruleText .=  '';
                    $this->rule = '';
                } else {
                    $this->newPrice = $this->currentItemPrice + abs($this->ruleItem['isUnder']['value']);
                    $this->ruleText .=  '';
                    $this->rule = '';
                }
            }
        } catch (Exception $e) {
            ExceptionLog::add($e, $this);
            if (App::environment('local')) { dump('Line: ' . $e->getLine() . '\r\n' . 'File: ' . $e->getFile() . '\r\n' . 'Message: ' . $e->getMessage() . '\r\n'); }

            return false;
        }
    }

    private function percentDiff()
    {
        try {
            if ($this->bbWin == 1) {
                $this->percentDiff = round(($this->currentItemPrice - $this->secondaryOfferPrice) / $this->secondaryOfferPrice * 100, 2);
                $this->ruleTextBandsOn = "<br>Difference is: $this->percentDiff% = ($$this->currentItemPrice - $$this->secondaryOfferPrice) / $$this->secondaryOfferPrice * 100";
            } elseif ($this->bbWin == 0) {
                $this->percentDiff = round(($this->currentItemPrice - $this->bbWinnerPrice) / $this->bbWinnerPrice * 100, 2);
                $this->ruleTextBandsOn = "<br>Difference is: $this->percentDiff% = ($$this->currentItemPrice - $$this->bbWinnerPrice) / $$this->bbWinnerPrice * 100";
            }

        } catch (Exception $e) {
            ExceptionLog::add($e, $this);
            if (App::environment('local')) { dump('Line: ' . $e->getLine() . '\r\n' . 'File: ' . $e->getFile() . '\r\n' . 'Message: ' . $e->getMessage() . '\r\n'); }

            return false;
        }
    }

    private function defineNoHistoryBandsOnRule($rules)
    {
        try {
            if ($this->bbWin == 1) {
                $filter = ['itemSpeed' => $this->currentItemSpeed, 'compSpeed' => $this->secondaryOfferSpeed, 'compProSeller' => $this->secondaryOfferPro];
            } elseif ($this->bbWin == 0) {
                $filter = ['itemSpeed' => $this->currentItemSpeed, 'compSpeed' => $this->bbWinnerSpeed, 'compProSeller' => $this->bbWinnerPro];
            }

            $filteredRules = array_values(array_filter(
                $rules,
                function ($key) use ($filter) {
                    return ($key['itemSpeed'] == $filter['itemSpeed'])
                        && ($key['compSpeed'] == $filter['compSpeed'])
                        && ($key['proSeller'] == $filter['compProSeller']);
                },
                ARRAY_FILTER_USE_BOTH
            ))[0];

            $nearestRule = null;
            $ruleAction = null;

            $this->percentDiff();

            foreach ($filteredRules['rules'] as $rule) {
                if ($rule['diff']['type'] == '%') {
                    if ($nearestRule) {
                        if (($nearestRule <= $rule['diff']['value'])
                        && ($this->percentDiff >= $rule['diff']['value'])) {
                            $nearestRule = $rule['diff']['value'];
                            $ruleAction = $rule;
                        }
                    } else {
                        $nearestRule = ($this->percentDiff >= $rule['diff']['value']) ? $rule['diff']['value'] : $nearestRule;
                        $ruleAction = empty($nearestRule) ? $rule : $ruleAction;
                    }
                } else {
                    //need rules for $, not present in initial requierements
                }
            }

            return $ruleAction;
        } catch (Exception $e) {
            ExceptionLog::add($e, $this);
            if (App::environment('local')) { dump('Line: ' . $e->getLine() . '\r\n' . 'File: ' . $e->getFile() . '\r\n' . 'Message: ' . $e->getMessage() . '\r\n'); }

            return false;
        }
    }

    private function getShippingSpeed($shippingMethod, $wfs, $sellerDisplayName)
    {
        try {
            switch ($shippingMethod) {
                case 'THREE_TO_FIVE_DAY':
                    if ($wfs) {
                        $shippingType = 'wfs';
                    } else {
                        $shippingType = 'reg';
                    }
                    break;

                case 'TWO_DAY':
                    if ($wfs) {
                        $shippingType = 'wfs';
                    } else {
                        $shippingType = '2d';
                    }
                    break;

                case 'ONE_DAY':
                    if ($sellerDisplayName == 'Walmart.com') {
                        $shippingType =  'walmart';
                    } else {
                        $shippingType = 0;
                    }
                    break;

                default:
                    $shippingType = '2d';
            }

            return $shippingType;
        } catch (Exception $e) {
            ExceptionLog::add($e, $this);
            if (App::environment('local')) { dump('Line: ' . $e->getLine() . '\r\n' . 'File: ' . $e->getFile() . '\r\n' . 'Message: ' . $e->getMessage() . '\r\n'); }

            return false;
        }
    }

    private function resultBelowMin()
    {
        try {
            if ($this->newPrice){
                if ($this->newPrice < $this->min) {
                    if ($this->itemRule) {
                        $this->ruleItem = $this->readRuleProperty('repriceRules.general.ifResultBelowMinPrice', $this->itemRule);
                    } else { //read default rule

                        $this->ruleItem = config('constants.repriceRules.general.ifResultBelowMinPrice');
                    }

                    $this->ruleItem = config('constants.repriceRules.general.ifResultBelowMinPrice'); //temp

                    if ($this->ruleItem == 'useMaxPrice') {
                        $this->newPrice = $this->max;
                        $this->ruleText .=  $this->ruleText . 'The price is bellow min price. Going to MAX price.';
                        $this->rule = 'The price is bellow min price. Going to MAX price.';
                        $this->ruleType = $this->ruleType . '.resultBelowMinPrice.' . $this->ruleItem;

                        return true;
                    } elseif ($this->ruleItem == 'useMinPrice') {
                        $this->newPrice = $this->min;
                        $this->ruleText .=  $this->ruleText . 'The price is bellow min price. Going to min price.';
                        $this->rule = 'The price is bellow min price. Going to min price.';
                        $this->ruleType = $this->ruleType . '.resultBelowMinPrice.' . $this->ruleItem;

                        return true;
                    } elseif ($this->ruleItem == 'doNothing') {
                        $this->ruleText .=  $this->ruleText . 'The price is bellow min price. Do nothing';
                        $this->rule = 'The price is bellow min price. Do nothing';
                        $this->ruleType = $this->ruleType . '.resultBelowMinPrice.' . $this->ruleItem;

                        return true;
                    }
                }
            }

            return false;
        } catch (Exception $e) {
            ExceptionLog::add($e, $this);
            if (App::environment('local')) { dump('Line: ' . $e->getLine() . '\r\n' . 'File: ' . $e->getFile() . '\r\n' . 'Message: ' . $e->getMessage() . '\r\n'); }

            return false;
        }
    }

    private function resultAboveMax()
    {
        try {
            if ($this->newPrice > $this->max) {
                if ($this->itemRule) {
                    $this->ruleItem = $this->readRuleProperty('repriceRules.general.ifResultAboveMaxPrice', $this->itemRule);
                } else { //read default rule
                    $this->ruleItem = config('constants.repriceRules.general.ifResultAboveMaxPrice');
                }

                $this->ruleItem = config('constants.repriceRules.general.ifResultAboveMaxPrice'); //temp

                if ($this->ruleItem == 'useMaxPrice') {
                    $this->newPrice = $this->max;
                    $this->ruleText .=  $this->ruleText . 'The price is above MAX price. Going to MAX price.';
                    $this->rule = 'The price is above MAX price. Going to MAX price.';
                    $this->ruleType = $this->ruleType . '.resultAboveMaxPrice.' . $this->ruleItem;

                    return false;
                    //return 'The price is above MAX price. Going to MAX price.';
                } elseif ($this->ruleItem == 'useMinPrice') {
                    $this->newPrice = $this->min;
                    $this->ruleText .=  $this->ruleText . 'The price is above MAX price. Going to min price.';
                    $this->rule = 'The price is above MAX price. Going to min price.';
                    $this->ruleType = $this->ruleType . '.resultAboveMaxPrice.' . $this->ruleItem;

                    return false;
                    //return 'The price is above MAX price. Going to min price.';
                } elseif ($this->ruleItem == 'doNothing') {
                    $this->ruleText .=  $this->ruleText . 'The price is above MAX price. Do nothing.';
                    $this->rule = 'The price is above MAX price. Do nothing.';
                    $this->ruleType = $this->ruleType . '.resultAboveMaxPrice.' . $this->ruleItem;

                    return false;
                } elseif ($this->ruleItem == 'goAboveMaxPrice') {
                    $this->ruleText .=  $this->ruleText . 'The price is above MAX price (go to above price is allowed). Going to new price which is above max price.';
                    $this->rule = 'The price is above MAX price. Go to above price.';
                    $this->ruleType = $this->ruleType . '.resultAboveMaxPrice.' . $this->ruleItem;

                    return 'The price is above MAX price (go to above price is allowed). Going to new price which is above max price.';
                }
            }
            return false;
        } catch (Exception $e) {
            ExceptionLog::add($e, $this);
            if (App::environment('local')) { dump('Line: ' . $e->getLine() . '\r\n' . 'File: ' . $e->getFile() . '\r\n' . 'Message: ' . $e->getMessage() . '\r\n'); }

            return false;
        }
    }

    private function getSellerDisplayName()
    {
        try {
            $lastSellerRecord = DB::table('buybox_reports')->
                                where('walmart_key_id', $this->item->walmart_key_id)->
                                latest('created_at')->
                                first();

            return $lastSellerRecord->seller_name;
        } catch (Exception $e) {
            ExceptionLog::add($e, $this);
            if (App::environment('local')) { dump('Line: ' . $e->getLine() . '\r\n' . 'File: ' . $e->getFile() . '\r\n' . 'Message: ' . $e->getMessage() . '\r\n'); }

            return false;
        }
    }

    // ********************** ADDITIONAL METHODS AND DATA VERIFY ****************************//
    private function repriceVerify()
    {
        try {
            if (($this->min == 0) || ($this->max == 0)) {
                $this->newPrice = $this->currentItemPrice;
                $this->ruleText .= $this->rule = 'The item was not repriced. MAX or min price was not set.';
                $this->ruleType = 'MinOrMaxZeroPrice';
                $this->cancelled = true;

                return false;
            }

            if ($this->min > $this->max) {
                $this->newPrice = $this->currentItemPrice;
                $this->ruleText .= $this->rule = 'The item was not repriced. MAX price higher than min price';
                $this->ruleType = 'MinOrMaxZeroPrice';
                $this->cancelled = true;

                return false;
            }


            if (!($this->item->qty >= 0)) {
                $this->newPrice = $this->currentItemPrice;
                $this->ruleText .= $this->rule = 'The item was not repriced. The item QTY is out of stock.';
                $this->cancelled = true;
                $this->ruleType = 'QtyIsZero';

                return false;
            } elseif ($this->item->qty == 0){
                if($this->checkOffersQty()){
                    $this->ruleText .= $this->rule = 'Via API Qty = 0, but item is present in offers. Continue reprice.';
                    return true;
                }

                $this->newPrice = $this->currentItemPrice;
                $this->cancelled = true;
                $this->ruleType = 'QtyIsZero';
                $this->ruleText .= $this->rule = 'The item was not repriced. The item QTY is out of stock. And not found in current offers.';

                return false;
            }

            if (($this->item->published_status == 'SYSTEM_PROBLEM') && ($this->item->force_repricing)){
                if($this->checkOffersQty()){
                    $this->ruleText .= $this->rule = 'Item has SYSTEM_PROBLEM status, but item is present in offers. Continue reprice.';
                    return true;
                }

                $this->ruleText .= $this->rule = 'Item has SYSTEM_PROBLEM status, but item is not present in offers. Reprice cancelled. Next check in 24h.';
                $this->nextReprice = date("Y-m-d H:i:s", strtotime('+24 hours'));

                return false;
            }

            if (($this->item->published_status != 'PUBLISHED') && ($this->item->published_status != 'SYSTEM_PROBLEM')) {
                $this->repriceUnpublished();

                return false;
            }


            return true;
        } catch (Exception $e) {
            ExceptionLog::add($e, $this);
            if (App::environment('local')) { dump('Line: ' . $e->getLine() . '\r\n' . 'File: ' . $e->getFile() . '\r\n' . 'Message: ' . $e->getMessage() . '\r\n'); }

            return false;
        }
    }

    private function checkOffersQty()
    {
        try {
            foreach($this->offers as $offer){
                if($offer->sellerDisplayName == $this->getSellerDisplayName()){
                    if ($offer->availabilityStatus == 'IN_STOCK'){
                        return true;
                    }
                    return false;
                }
            }

            return false;
        } catch (Exception $e) {
            ExceptionLog::add($e, $this);
            if (App::environment('local')) { dump('Line: ' . $e->getLine() . '\r\n' . 'File: ' . $e->getFile() . '\r\n' . 'Message: ' . $e->getMessage() . '\r\n'); }

            return false;
        }
    }

    public function repriceUnpublished()
    {
        try {
            if ($this->item->published_status == 'UNPUBLISHED') {
                if (($this->item->status_change_reason == 'Reasonable price requirements are not met,Reasonable Price Not Satisfied')
                    || ($this->item->status_change_reason == 'Reasonable Price Not Satisfied,Reasonable Price Not Satisfied')
                    || ($this->item->status_change_reason == 'Reasonable Price Not Satisfied')
                    || ($this->item->status_change_reason == "'Reasonable Price Not Satisfied,Reasonable Price Not Satisfied'")
                    || ($this->item->status_change_reason == "'Reasonable price requirements are not met,Reasonable Price Not Satisfied'")
                ) {

                    $this->ruleItem = config('constants.repriceRules.general.unpublishedAndActive');

                    if ($this->getUnpublishedHours() == 0) {
                        if ($this->item->amazon_competitor_price > 0) {
                            $this->newPrice = $this->item->amazon_competitor_price * (100 + $this->ruleItem['value']) / 100;
                            $this->ruleText .=  'Unpublished rule applied';
                            $this->rule = 'Unpublished rule applied';
                            $this->ruleType = 'unpablishedRule';
                        } else {
                            $this->newPrice = $this->item->current_price * (100 - $this->ruleItem['mpPriceNotExist']['value']) / 100;
                            $this->ruleText .=  'Unpublished rule applied';
                            $this->rule = 'Unpublished rule applied';
                            $this->ruleType = 'unpablishedRule';
                        }
                    } elseif ($this->getUnpublishedHours() >= 2) {
                        $this->newPrice = $this->item->current_price * (100 - $this->ruleItem['mpPriceNotExist']['value']) / 100;
                        $this->ruleText .=  'Unpublished rule applied';
                        $this->rule = 'Unpublished rule applied';
                        $this->ruleType = 'unpablishedRule';
                    } else {
                        $this->ruleText .=  'Unpublished rule applied';
                        $this->rule = 'Unpublished rule applied';
                        $this->ruleType = 'unpablishedRule';
                        $this->newPrice = $this->item->current_price;
                    }
                } else {
                    $this->newPrice = $this->currentItemPrice;
                    $this->ruleText .= $this->rule = 'Looks some issue with scrapping offers on Walmart';
                    $this->cancelled = true;
                    $this->ruleType = 'scrapOffersIssue';
                }
            }
        } catch (Exception $e) {
            ExceptionLog::add($e, $this);
            if (App::environment('local')) { dump('Line: ' . $e->getLine() . '\r\n' . 'File: ' . $e->getFile() . '\r\n' . 'Message: ' . $e->getMessage() . '\r\n'); }

            return false;
        }
    }

    public function readRuleProperty($property, $rule)
    {
        try {
            $keys = explode('.', $property);
            $arrayTemp = [];

            if ($keys) {
                for ($i = 0; $i < count($keys); $i++) {
                    $key = $keys[$i];
                    if ($i == 0) {
                        if (isset($rule[$key])) {
                            $arrayTemp = $rule[$key];
                        }
                    } else {
                        if (isset($arrayTemp[$key])) {
                            $arrayTemp = $arrayTemp[$key];
                        }
                    }
                }

                return $arrayTemp;
            }

            return false;
        } catch (Exception $e) {
            ExceptionLog::add($e, $this);
            if (App::environment('local')) { dump('Line: ' . $e->getLine() . '\r\n' . 'File: ' . $e->getFile() . '\r\n' . 'Message: ' . $e->getMessage() . '\r\n'); }

            return false;
        }
    }

    private function updateManual()
    {
        try {
            $this->hiAndLow();
            $this->itemActivity->item_id = $this->item->id;
            $this->itemActivity->prev_activity_id = ($this->lastItemActivity) ? $this->lastItemActivity->id : null;
            $this->itemActivity->offers = json_encode($this->offers);
            $this->itemActivity->prev_offers = $this->lastItemActivity->offers ?? null;
            //$this->itemActivity->scrap = json_encode($this->itemData);
            $this->itemActivity->used_rule = $this->rule;
            $this->itemActivity->bbWin = $this->bbWin;
            $this->itemActivity->buybox_price = $this->bbWinnerPrice  ?? 0;
            $this->itemActivity->percent = $this->percent ?? 0;
            $this->itemActivity->abs = abs($this->abs);
            $this->itemActivity->high = $this->high;
            $this->itemActivity->low = $this->low;
            $this->itemActivity->comp_ship_type = $this->compShipType;
            $this->itemActivity->low_reg = $this->low_reg;
            $this->itemActivity->low_wfs = $this->low_wfs;
            $this->itemActivity->low_2d = $this->low_2d;
            $this->itemActivity->low_walmart = $this->low_walmart;
            $this->itemActivity->hi_reg = $this->hi_reg;
            $this->itemActivity->hi_wfs = $this->hi_wfs;
            $this->itemActivity->hi_2d = $this->hi_2d;
            $this->itemActivity->hi_walmart = $this->hi_walmart;
            $this->itemActivity->offers_count = $this->offersCount;
            $this->itemActivity->cancelled = false;
            $this->itemActivity->status = 1;

            if ($this->itemData == null) {
                $this->itemActivity->description = 'The item was not repriced. Looks Item is unpublished and not present on Walmart';
            }

            if ($this->bbWinOld) {
                $this->itemActivity->bbWin_old = 1;
            } else {
                $this->itemActivity->bbWin_old = 0;
            }

            /*$itemLastActivities =   ItemActivity::where('item_id', $this->item->id)->
                                    where(function ($q) {
                                        $q->where('cancelled', null)->orWhere('cancelled', false);
                                    })->
                                    orderBy('id', 'desc')->get();
            */

            if ($this->lastItemActivities) {
                if (!empty($this->lastItemActivities[1])) {
                    $this->itemActivity->bbWin_old = $this->lastItemActivities[1]->bbWin;
                } else {
                    $this->itemActivity->bbWin_old = null;
                }
            } else {
                $this->itemActivity->bbWin_old = null;
            }

            $this->itemActivity->save();

            if ($this->item) {
                $this->item->offers_count = $this->offersCount ?? 0;
                $this->item->current_price = $this->currentItemPrice ? $this->currentItemPrice : $this->item->current_price;
                $this->item->buy_box_price = $this->bbWinnerPrice ? $this->bbWinnerPrice : $this->item->buy_box_price;
                $this->item->buy_box_won = $this->bbWin;
                $this->item->buy_box_date = Carbon::now();
                $this->item->save();
            }
        } catch (Exception $e) {
            ExceptionLog::add($e, $this);
            if (App::environment('local')) { dump('Line: ' . $e->getLine() . '\r\n' . 'File: ' . $e->getFile() . '\r\n' . 'Message: ' . $e->getMessage() . '\r\n'); }

            return false;
        }
    }

    private function updateItemActivity($cancelled = null, $reason = null, $rule = null)
    {
        try {
            $this->hiAndLow();

            $this->itemActivity->item_id = $this->item->id;
            $this->itemActivity->prev_activity_id = ($this->lastItemActivity) ? $this->lastItemActivity->id : null;
            $this->itemActivity->description = $this->ruleText;
            $this->itemActivity->offers = json_encode($this->offers);
            //$this->itemActivity->scrap = json_encode($this->itemData);
            $this->itemActivity->old_price = $this->currentItemPrice;
            $this->itemActivity->used_rule = $this->rule;
            $this->itemActivity->bbWin = $this->bbWin;
            $this->itemActivity->buybox_price = $this->bbWinnerPrice;
            $this->itemActivity->percent = $this->percent;
            $this->itemActivity->abs = abs($this->abs);
            $this->itemActivity->high = $this->high;
            $this->itemActivity->low = $this->low;
            $this->itemActivity->comp_ship_type = $this->compShipType;
            $this->itemActivity->low_reg = $this->low_reg;
            $this->itemActivity->low_wfs = $this->low_wfs;
            $this->itemActivity->low_2d = $this->low_2d;
            $this->itemActivity->low_walmart = $this->low_walmart;
            $this->itemActivity->hi_reg = $this->hi_reg;
            $this->itemActivity->hi_wfs = $this->hi_wfs;
            $this->itemActivity->hi_2d = $this->hi_2d;
            $this->itemActivity->hi_walmart = $this->hi_walmart;
            $this->itemActivity->offers_count = $this->offersCount;
            $this->itemActivity->min_price = $this->min;
            $this->itemActivity->max_price = $this->max;
            $this->itemActivity->location = $this->itemData->fulfillmentLabel[0]->locationText;
            $this->itemActivity->save();
            $this->itemActivity->refresh();

            if ($this->pause_reprice) {
                if($this->next_reprice){
                    $this->itemActivity->pause_reprice = $this->pause_reprice;
                    $this->itemActivity->next_reprice = $this->next_reprice;
                }
            }



            if ($this->rule == 'Exception of Rule 2') {
                $this->itemActivity->description = 'Going back to max Hi.' . $this->itemActivity->description;
            }

            if ($this->itemData == null) {
                $this->itemActivity->description = 'The item was not repriced. Looks Item is unpublished and not present on Walmart';
            }

            if ($this->newPrice) {
                $this->itemActivity->new_price = $this->newPrice;
            } else {
                $this->itemActivity->new_price =  $this->itemActivity->old_price;
            }

            if (($reason) && ($cancelled)) {
                $this->itemActivity->rule = $reason;
                $this->itemActivity->cancelled = true;
            } else {
                $this->itemActivity->rule = $rule;
                $this->itemActivity->cancelled = false;
            }

            if (($this->min != 0) && ($this->max != 0) && ($this->item->qty > 0) && ($this->item->published_status == 'PUBLISHED')) {
                if ($this->resultBelowMin()) {
                    $this->itemActivity->rule = $this->rule;
                    //$this->itemActivity->new_price = $this->newPrice;
                } elseif(empty($this->newPrice)) {
                    $this->itemActivity->description = 'The item was not repriced. Not enough parameters to reprice. Needs to be check by developer';
                } else {
                    $this->itemActivity->new_price = $this->newPrice;
                }

                if ($this->resultAboveMax()) {
                    $this->itemActivity->rule = $this->rule;
                    //$this->itemActivity->new_price = $this->newPrice;
                } elseif(empty($this->newPrice)) {
                    $this->itemActivity->description = 'The item was not repriced. Not enough parameters to reprice. Needs to be check by developer';
                } else {
                    $this->itemActivity->new_price = $this->newPrice;
                }
            } else {
                if (($this->min == 0) || ($this->max == 0)) {
                    $this->itemActivity->description = 'The item was not repriced. MAX or min price was not set.';
                }

                if (!($this->item->qty > 0)) {
                    $this->itemActivity->description = 'The item was not repriced. The item QTY out of stock.';
                }

                if ($this->item->published_status != 'PUBLISHED') {
                    $this->itemActivity->description = 'The item was not repriced. The item not publish.';
                }
            }

            $this->itemActivity->description = $this->ruleText;
            $this->itemActivity->rule_type = $this->ruleType;

            if ($this->offers) {
                $offersCount = count($this->offers);

                if (($offersCount == 1) && ($this->item->published_status == 'PUBLISHED')) {
                    if ($this->offers[0]->sellerDisplayName != $this->getSellerDisplayName()) {
                        $this->itemActivity->rule = 'Price not changed. Looks some issue, the item is not present on Walmart';
                        $this->itemActivity->description = 'Price not changed. Looks some issue, the item is not present on Walmart';
                        $this->itemActivity->cancelled = true;
                        $this->itemActivity->new_price =  $this->itemActivity->old_price;
                        $this->newPrice = $this->itemActivity->old_price;
                    }
                }
            } else {
                $this->itemActivity->rule = 'Price not changed. Looks some issue with scrapping offers on Walmart';
                $this->itemActivity->description = 'Price not changed. Looks some issue with scrapping offers on Walmart';
                $this->itemActivity->cancelled = true;
                $this->itemActivity->new_price =  $this->itemActivity->old_price;
                $this->newPrice = $this->itemActivity->old_price;
            }

            if ($this->bbWin) {
                $this->itemActivity->bbWin_old = 1;
            } else {
                if ($this->bbWinOld === 0){
                    $this->itemActivity->bbWin_old = 0;
                } else {
                    $this->itemActivity->bbWin_old = null;
                }
            }

            if ($this->itemActivity->rule == '1. BandsON'){
                $this->itemActivity->bbWin_old = $this->bbWin;
            }

            $this->itemActivity->save();

            $this->item->offers_count = $this->offersCount ?? 0;
            $this->item->current_price = $this->currentItemPrice;
            $this->item->buy_box_won = $this->bbWin;
            $this->item->buy_box_price = $this->bbWinnerPrice ? $this->bbWinnerPrice : $this->item->buy_box_price;
            $this->item->buy_box_date = date("Y-m-d H:i:s");
            $this->item->save();

            return $this->itemActivity;
        } catch (Exception $e) {
            ExceptionLog::add($e, $this);
            if (App::environment('local')) { dump('Line: ' . $e->getLine() . '\r\n' . 'File: ' . $e->getFile() . '\r\n' . 'Message: ' . $e->getMessage() . '\r\n'); }

            return false;
        }
    }

    private function hasCompetitions()
    {
        try {
            if (count($this->offers) > 1) {
                return true;
            }

            return false;
        } catch (Exception $e) {
            ExceptionLog::add($e, $this);
            if (App::environment('local')) { dump('Line: ' . $e->getLine() . '\r\n' . 'File: ' . $e->getFile() . '\r\n' . 'Message: ' . $e->getMessage() . '\r\n'); }

            return false;
        }
    }

    private function hiAndLow()
    {
        try {
            $this->percent = self::calcPercent($this->currentItemPrice, $this->bbWin ? $this->secondaryOfferPrice : $this->bbWinnerPrice);

            if ($this->winLostPrice){
                if ($this->bbWin){
                    $this->low = $this->winLostPrice->lbblp_current;

                    if ($this->winLostPrice->hbbwp_current < $this->percent){
                        $this->high = $this->percent;
                    } else {
                        $this->high = $this->winLostPrice->hbbwp_current;
                    }
                } else {
                    if ($this->winLostPrice->lbblp_current > $this->percent){
                        $this->low = $this->percent;
                    } else {
                        $this->low = $this->winLostPrice->lbblp_current;
                    }

                    if ($this->winLostPrice->hbbwp_current > $this->low) {
                        $this->high = null;
                        $this->winLostPrice->hbbwp_current = null;
                        $this->winLostPrice->save();
                    } else {
                        $this->high = $this->winLostPrice->hbbwp_current;
                    }
                }
            } else {
                if ($this->bbWin){
                    $this->high = $this->percent;
                    $this->low = 9999.12345678;
                } else {
                    $this->low = $this->percent;
                    $this->high = -9999.12345678;
                }
            }

            if ($this->high == -9999.12345678) {
                $hi = 0;
            } else {
                $hi = $this->high;
            }

            if ($this->low == 9999.12345678) {
                $low = 0;
            } else {
                $low = $this->low;
            }

            $this->abs = abs($hi - $low);

        } catch (Exception $e) {
            ExceptionLog::add($e, $this);
            if (App::environment('local')) { dump('Line: ' . $e->getLine() . '\r\n' . 'File: ' . $e->getFile() . '\r\n' . 'Message: ' . $e->getMessage() . '\r\n'); }

            return false;
        }
    }

    private static function calcPercent($itemPrice = null, $compPrice = 0)
    {
        try {
            if (isset($itemPrice)) {
                if (($compPrice ?? 0) > 0) {
                    return ($itemPrice - $compPrice) / $compPrice;
                }
            }

            return false;
        } catch (Exception $e) {
            ExceptionLog::add($e, get_defined_vars());
            if (App::environment('local')) { dump('Line: ' . $e->getLine() . '\r\n' . 'File: ' . $e->getFile() . '\r\n' . 'Message: ' . $e->getMessage() . '\r\n'); }

            return false;
        }
    }

    private function getCompetitionsForBbWin()
    {
        if (!empty($this->offers)) {
            if (count($this->offers) > 1) {
                $this->compPrice = $this->offers[1]->priceInfo->currentPrice->price;
                $this->compSpeed = $this->getShippingSpeed($this->offers[1]->shippingOption->slaTier, $this->offers[1]->wfsEnabled, $this->offers[1]->sellerDisplayName);
            } elseif (count($this->offers) == 1) {
                $this->compPrice = 0;
                $this->compSpeed = 'reg';
            }
        }
    }

    private function getCompetitionsForBbLost()
    {
        if (!empty($this->offers)) {
            if (count($this->offers) > 1) {
                $this->compPrice = $this->offers[0]->priceInfo->currentPrice->price;
                $this->compSpeed = $this->getShippingSpeed($this->offers[0]->shippingOption->slaTier, $this->offers[0]->wfsEnabled, $this->offers[0]->sellerDisplayName);
            } elseif (count($this->offers) == 1) {
                $this->compPrice = 0;
                $this->compSpeed = 'reg';
            }
        }
    }

    private function getAndFillBBPrices()
    {
        try {
            if (!$this->winLostPrice){ //if record not exist
                $this->winLostPrice = new WinLostPrices();
                $this->winLostPrice->item_id = $this->item->id;

                if ($this->bbWin){
                    $this->winLostPrice->win_current = $this->currentItemPrice;
                } else {
                    $this->winLostPrice->lost_current = $this->currentItemPrice;
                }

                $this->winLostPrice->save();
                $this->winLostPrice->refresh();
            }

            if ($this->bbWin){
                $this->winLostPrice->win_current = $this->currentItemPrice;

                if ($this->percent > $this->winLostPrice->hbbwp_current){
                    $this->winLostPrice->hbbwp_current = $this->percent;
                }
            } else {
                $this->winLostPrice->lost_current = $this->currentItemPrice;

                if ($this->percent < $this->winLostPrice->lbblp_current){
                    $this->winLostPrice->lbblp_current = $this->percent;
                }
            }

            $this->winLostPrice->bb_win = $this->bbWin;

            if (isset($this->lastItemActivity->bbWin)) {
                $this->winLostPrice->bb_win_old = $this->lastItemActivity->bbWin;
            }

            $this->winLostPrice->comp_speed_current = $this->compSpeed;

            $this->winLostPrice->update();

        } catch (Exception $e) {
            ExceptionLog::add($e, $this);
            if (App::environment('local')) { dump('Line: ' . $e->getLine() . '\r\n' . 'File: ' . $e->getFile() . '\r\n' . 'Message: ' . $e->getMessage() . '\r\n'); }

            return false;
        }
    }

    public function updateActivity()
    {
        try {
            $pageData = null;

            $this->item->offers_count = $this->offersCount ?? 0;
            $this->item->current_price = $this->currentItemPrice;
            $this->item->buy_box_won = $this->bbWin;
            $this->item->buy_box_price = $this->bbWinnerPrice ? $this->bbWinnerPrice : $this->item->buy_box_price;
            $this->item->buy_box_date = date("Y-m-d H:i:s");
            $this->item->save();

            $this->itemActivity->bbWin = $this->bbWin;
            $this->itemActivity->status = 1;
            $this->itemActivity->base_rule = $this->lastState;
            $this->hiAndLow();

            if ($this->bbWin) {
                $this->getCompetitionsForBbWin();
            } else {
                $this->getCompetitionsForBbLost();
            }

            $this->itemActivity->comp_price = $this->compPrice;
            $this->itemActivity->comp_ship_type = $this->compSpeed;

            if ($this->bbWin) {
                $this->itemActivity->high = $this->high;
                $this->itemActivity->buybox_price = $this->itemActivity->new_price;
            } else {
                $this->itemActivity->low = $this->low;
                $this->itemActivity->buybox_price = $this->bbWinnerPrice;
            }

            if (($this->bbWin == false) && ($this->bbWinOld == true)) {
                if ($this->lastState <> 'noHistory') {
                    ItemActivity::  where('item_id', $this->lastItemActivity->item_id)->
                                    where('bbWin', true)->
                                    where('high', '=', $this->high)->
                                    where('rule','<>', '1. BandsON')->
                                    update(['skip' => 1]);
                }
            }

            if ($this->pause_reprice) {
                if($this->next_reprice){
                    $this->itemActivity->pause_reprice;
                    $this->itemActivity->next_reprice;
                }
            }

            $this->itemActivity->prev_offers = $this->itemActivity->offers;
            $this->itemActivity->offers = json_encode($this->offers);

//            $lastItemActivity = ItemActivity::where('item_id', $this->item->id)->
//                                                where('status',1)->
//                                                orderBy('id', 'desc')->
//                                                first();

            if($this->winLostPrice){
                $this->itemActivity->bbWin_old = $this->winLostPrice->bb_win;
            } else {
                $this->itemActivity->bbWin_old = null;
            }

            $this->itemActivity->save();

            $this->getAndFillBBPrices();

        } catch (Exception $e) {
            ExceptionLog::add($e, get_defined_vars());
            if (App::environment('local')) { dump('Line: ' . $e->getLine() . '\r\n' . 'File: ' . $e->getFile() . '\r\n' . 'Message: ' . $e->getMessage() . '\r\n'); }

            return false;
        }
    }

    private function getUnpublishedHours()
    {
        try {
            $unpublishInstances = ItemActivity::where('item_id', $this->item->id)->
                                                whereNotNull('publish_next_reprice')->
                                                orderBy('id', 'desc')->
                                                select('id', 'publish_next_reprice')->
                                                first();

            if (!empty($unpublishInstances->publish_next_reprice)) {
                $diff = $unpublishInstances->publish_next_reprice->diffInHours(now());

                return $diff;
            } else {
                return 0;
            }
        } catch (Exception $e) {
            ExceptionLog::add($e, $this);
            if (App::environment('local')) { dump('Line: ' . $e->getLine() . '\r\n' . 'File: ' . $e->getFile() . '\r\n' . 'Message: ' . $e->getMessage() . '\r\n'); }

            return false;
        }
    }

    public static function canceledHistory($item, $itemActivity, $currentOffers, $jsonData, $message, $param = null)
    {
        try {
            $newItemActivity = new ItemActivity();
            $newItemActivity->item_id = $item->id;
            $newItemActivity->rule = 'The rule is undefined.';
            $newItemActivity->prev_activity_id = ($itemActivity) ? $itemActivity->id : null;
            $newItemActivity->description = $message;
            $newItemActivity->offers = $currentOffers;
            //$newItemActivity->scrap = $jsonData;
            $newItemActivity->cancelled = !$param ? false : true;
            $newItemActivity->save();
            /*
            $reprHist = new RepricingHistory();
            $reprHist->item_id = $item->id;
            $reprHist->rule = 'The rule is undefined.';
            $reprHist->prev_activity_id = ($itemActivity) ? $reprHist->id : null;
            $reprHist->description = $message;
            $reprHist->other_comp = $currentOffers;
            $reprHist->scrap = $jsonData;
            unset($reprHist->abs);

            if (!$param) {
                $reprHist->cancelled = false;
            }

            $reprHist->save();
            */

            return $newItemActivity->id;
        } catch (Exception $e) {
            ExceptionLog::add($e, get_defined_vars());
            if (App::environment('local')) { dump('Line: ' . $e->getLine() . '\r\n' . 'File: ' . $e->getFile() . '\r\n' . 'Message: ' . $e->getMessage() . '\r\n'); }

            return false;
        }
    }

    public static function repriceDelay($item)
    {
        try {
            $itemActivities = ItemActivity::where('item_id', $item->id)
                ->where('cancelled', '<>', true)
                ->select('id', 'next_reprice')
                ->orderBy('id', 'desc')
                ->limit(3)
                ->get();

            if (count($itemActivities) > 1) {
                if (!$itemActivities[0]->next_reprice) {
                    return false;
                }

                $repriceTime = new Carbon($itemActivities[0]->next_reprice);

                if ($repriceTime->gt(Carbon::now())) {
                    return true;
                }

                return false;
            }

            return false;
        } catch (Exception $e) {
            ExceptionLog::add($e, $itemActivities);
            if (App::environment('local')) { dump('Line: ' . $e->getLine() . '\r\n' . 'File: ' . $e->getFile() . '\r\n' . 'Message: ' . $e->getMessage() . '\r\n'); }

            return false;
        }
    }

    public static function repriceDelayCondition($item)
    {
        try {
            $itemActivities = ItemActivity::where('item_id', $item->id)
                ->where('status', 1)
                ->where('cancelled', '<>', true)
                ->select('id', 'new_price', 'rule_type', 'next_reprice')
                ->orderBy('id', 'desc')
                ->limit(3)->get();

            if (count($itemActivities) >= 3) {
                if ((($itemActivities[0]->new_price == $itemActivities[1]->new_price) && ($itemActivities[1]->new_price == $itemActivities[2]->new_price))
                    && (($itemActivities[0]->rule_type == $itemActivities[1]->rule_type) && ($itemActivities[1]->rule_type == $itemActivities[2]->rule_type))
                ) {

                    if ($itemActivities[0]->next_reprice) {
                        return false;
                    } else {
                        return true;
                    }
                } else {
                    return false;
                }
            }
        } catch (Exception $e) {
            ExceptionLog::add($e, $itemActivities);
            if (App::environment('local')) { dump('Line: ' . $e->getLine() . '\r\n' . 'File: ' . $e->getFile() . '\r\n' . 'Message: ' . $e->getMessage() . '\r\n'); }

            return false;
        }
    }
    private function cleanHiAndLow()
    {
        if ($this->high == -9999.12345678) {
            $this->high = -0.00000001;
        }

        if ($this->low == 9999.12345678) {
            $this->low = 0.00000001;
        }

        $this->incrementLost = ($this->high - $this->low) / 2;
        $this->incrementWin = ($this->low - $this->high) / 2;
        $this->abs = abs($this->low - $this->high);
    }

    private function getWinLostPrice()
    {
        if ($this->bbWin){
            $this->winPrice = $this->currentItemPrice;
            $this->lostPrice = $this->winLostPrice->lost_current;
        } else {
            $this->lostPrice = $this->currentItemPrice;
            $this->winPrice = $this->winLostPrice->win_current;
        }
    }

    private function rule_2_1()
    {
        if (abs($this->winPrice - $this->lostPrice) <= 0.02) {
            $this->newPrice = $this->winPrice;
            $this->ruleText .=  "Rule 2-1-2. The difference between WinPrice ans LostPrice is less than 0.02. Going to last BB price. abs($$this->winPrice - $$this->lostPrice) <= 0.02<br/>";
            $this->rule = '2-1-2';
        } else {

            $this->newPrice = round(($this->winPrice + $this->lostPrice)/2, 2);
            $this->ruleText .= "Rule 2-1-1: Same shippng method and same price. newPrice = (winPrice + lostPrice) / 2.<br/>";
            $this->ruleText .="$$this->newPrice = ($$this->winPrice + $$this->lostPrice) / 2<br/>";
            $this->rule = '2-1-1';
        }
    }

    private function rule_2_2() //2-2-1, 2-2-3
    {
        if ($this->high > $this->low) {
            $this->rule_2_3();
            $this->rule .= '<= 2-2-1';
            $this->ruleText .= '<br> Defined like rule 2-2-1 and forwarded to rule 2-3, becuase we are at BB hi percentage or higher.';
            $this->skipHiAndLow();
        } elseif ((abs($this->winPrice - $this->lostPrice) <= 0.02) && ($this->lastItemActivity->rule <> "1. BandsON")){
            $this->newPrice = $this->getLastBestBBPrice();
            $this->rule = '2-2-3';
            $this->ruleText .=  'Rule 2-2-3 the difference is less than $0.02. Going to last BB price.';
        } else {
            $this->newPrice =  round(($this->winPrice + $this->lostPrice)/2, 2);
            $this->ruleText .= "Rule 2-2-1: Same shippng method and same price. newPrice = (winPrice + lostPrice) / 2.<br/>";
            $this->ruleText .="$$this->newPrice = ($$this->winPrice + $$this->lostPrice) / 2<br/>";
            $this->rule = '2-2-1';
        }

    }

    private function rule_2_2_2()
    {
        $this->newPrice = round($this->bbWinnerPrice + $this->bbWinnerPrice * $this->high, 2);
        $this->ruleText .=  'Rule 2-2-2: Lost more than 3 times. newPrice = compPrice + compPrice x hi. <br>';
        $this->ruleText .="($$this->newPrice = $$this->bbWinnerPrice + $$this->bbWinnerPrice x $$this->high)";
        $this->rule = '2-2-2';
    }

    private function rule_2_3()
    {
        $this->ruleText .=  'Rule 2-3: HBWWP greater than LBBLP. ';
        $this->dropHbbwpAndLbblp();
        $this->resultNoHistory();
        $this->rule = '2-3';
    }

    private function rule_3_1()
    {
        if (abs($this->winPrice - $this->lostPrice) > 0.02) { //3-1-1
            //go up with $increment
            $this->newPrice = round(($this->winPrice + $this->lostPrice)/2, 2);
            $this->ruleText .= "Rule 3-1-1(3-2-2): Same shippng method and same price. newPrice = (winPrice + lostPrice) / 2<br>" .
            $this->ruleText .= "($$this->newPrice = ($$this->winPrice + $$this->lostPrice) / 2)";
            $this->rule = '3-1-1';
        } else { //3-1-2
            //stay on current postion
            $this->newPrice = $this->currentItemPrice;
            $this->ruleText .=  'Rule 3-1-2: The difference is less then $0.02. The price stay on current position next 30h until near competitor not change the price. ';
            $this->rule = '3-1-2-p';
            //$this->pause_reprice = date("Y-m-d H:i:s", strtotime('+30 hours'));
            $this->next_reprice = date("Y-m-d H:i:s", strtotime('+1 hours'));
        }

    }

    private function rule_3_2()
    {
        $percent = ($this->currentItemPrice - $this->secondaryOfferPrice) / $this->secondaryOfferPrice;

        if ($this->high < $percent) { //3-2-2
            $this->newPrice = round(($this->winPrice + $this->lostPrice)/2, 2);
            $this->ruleText .=  "Rule 3-2-2: Same shippng method and diff price.  newPrice = (winPrice + lostPrice) / 2. <br>"; //The price stay on current position next 30h.
            $this->ruleText .= "($$this->newPrice = ($$this->winPrice + $$this->lostPrice) / 2)";
            $this->rule = '3-2-2';
            //$this->pause_reprice = date("Y-m-d H:i:s", strtotime('+30 hours'));
           //$this->next_reprice = date("Y-m-d H:i:s", strtotime('+1 hours'));
        } else { //3-2-1
            $this->newPrice = $this->compPrice * $this->high + $this->compPrice;
            $this->ruleText .=  'Rule 3-2-1: Same shippng method and diff price. newPrice = compPrice + compPrice x abs(high). ';
            $this->ruleText .= "($$this->newPrice = $$this->compPrice + $$this->compPrice x abs($this->high))";
            $this->rule = '3-2-1';

            if (abs($this->winPrice - $this->lostPrice) <= 0.02){
                //$this->pause_reprice = date("Y-m-d H:i:s", strtotime('+30 hours'));
                $this->newPrice = $this->currentItemPrice;
                $this->ruleText .=  'Rule 3-2-2: The difference is less then $0.02. The price stay on current position next 30h until near competitor not change the price. ';
                $this->rule = '3-2-2-p';
                //$this->pause_reprice = date("Y-m-d H:i:s", strtotime('+30 hours'));
                $this->next_reprice = date("Y-m-d H:i:s", strtotime('+1 hours'));
            }
        }
    }

    private function dropHbbwpAndLbblp()
    {
        $this->high = -9999.12345678;
        $this->low = 9999.12345678;

        $this->winLostPrice->hbbwp_current = $this->high;
        $this->winLostPrice->lbblp_current = $this->low;
        $this->winLostPrice->save();

    }

    private function rule_3_3()
    {
        $this->ruleText .=  "Rule 3.3. HBBWP > LBBLP. Skip this HBBWP and go to noHistory rule <br>";
        $this->dropHbbwpAndLbblp();
        $this->resultNoHistory();
    }

    private function rule_3_4()
    {
        $this->newPrice = round($this->currentItemPrice * 0.05 + $this->currentItemPrice, 2);
        $this->ruleText .=  "Rule 3.4: newPrice = currPrice + currPrice x 0.05. <br>";
        $this->ruleText .=  "($$this->newPrice = $$this->currentItemPrice  + $$this->currentItemPrice x 0.05)";
        $this->rule = '3-4';
        $this->ruleType = 'wonAfterWin';
    }


    private function rule_3_5()
    {
        $this->newPrice = $this->secondaryOfferPrice + ($this->high) * $this->secondaryOfferPrice;
        $this->ruleText .=  'Rule 3.5: Don\'t have any BBlost, used rule 3.5. newPrice = compPrice + compPrice x hi. ($' .
                            round($this->newPrice, 2) . ' = $' . $this->secondaryOfferPrice . ' + $' .
                            $this->secondaryOfferPrice . ' x ' .  ($this->high) . ')';
        $this->rule = '3-5';
        $this->ruleType = 'wonAfterWin';
        /*
        if ($this->newPrice == $this->currentItemPrice) {
            if ($this->high == -9999.12345678) {
                $hi = 0;
            } else {
                $hi = $this->high;
            }

            if ($this->low == 9999.12345678) {
                $low = 0;
            } else {
                $low = $this->low;
            }

            $increment = abs(($hi - $low) / 2);
            $this->newPrice = $this->currentItemPrice + $increment * $this->currentItemPrice;
            $this->ruleText .=  'Rule 3.10 (new): The rule 3.5 not take affect price was not changed. Changing formula to newPrice = currentItemPrice + currentItemPrice x abs(hi - low)/2. ($' .
                                round($this->newPrice, 2) . ' = $' . $this->currentItemPrice . ' + $' .
                                $this->currentItemPrice . ' x ' . $increment . ')';
            $this->rule = '3-5->3.10';
            $this->ruleType = 'wonAfterWin';
        }
        */
    }


}
