<?php

namespace App\Services;
use App\Models\ItemActivity;
use App\Models\Item;
use App\Models\WalmartKey;
use Carbon\Carbon;

class OldEventService
{
    private $activity;
    private $scrappedProduct;
    private $min;
    private $max;
    private $bbWin;
    private $bbWinPrev;
    private $bbWinPrice;
    private $itemDB;
    private $currentPrice;
    private $newPrice;
    private $description;
    private $cancelled;
    private $status;
    private $nextSchedule;
    private $percent;
    private $prevHi;
    private $prevLow;
    private $hi;
    private $low;
    private $abs;

    public const EVENT_TYPE_NOTIFICATION = 1;
    public const EVENT_TYPE_BUYBOX = 2;
    public const EVENT_TYPE_SHORT_SCRAPE = 3;
    public const EVENT_TYPE_FULL_SCRAPE = 4;

    public function __construct($queue_data)
    {
        $this->activity = $queue_data['activity'];
        $this->scrappedProduct = $this->toObject($queue_data['scrape_data']['product']);
        $this->prepareData();
        //dump('-----------------------------------------------------------------','https://www.walmart.com/ip/'. $this->itemDB->walmart_item_id);
    }

    public function process()
    {
        /* Need to delete before deoplyment */
//            $this->activity->status = 2;
//            $this->activity->save();
        /* END OF Need to delete before deoplyment */
        //dump('Processing:', 'Activity: '. $this->activity->id, 'BBWIN: '. $this->bbWin, 'Current price: '. $this->currentPrice);
        $this->getPrevHiAndLow();
        $this->getCurrentHiAndLow();

        if($this->itemDB->next_schedule){
            //dump($this->itemDB->next_schedule > Carbon::now());
            if ($this->itemDB->next_schedule > Carbon::now()){
                $this->activity->description = 'Paused.';
                $this->activity->status = 2;
                $this->activity->save();

                return false;
            }
        }

        if (!empty($this->scrappedProduct->availabilityStatus)) {
            if ($this->scrappedProduct->availabilityStatus == 'OUT_OF_STOCK') {
                $this->activity->description = 'Unsuccessful reprice. The item OUT OF STOCK. ';
                $this->activity->status = 2;
                $this->activity->save();

                $this->itemDB->is_repricing = 0;
                $this->itemDB->qty = 0;
                $this->itemDB->save();

                return false;
            }
        }

        if (!$this->scrappedProduct->sellerDisplayName) {
            $this->activity->description = 'Unsuccessful scrapping. Next try after 5-10 minutes. Changing Proxy...';
            $this->activity->status = 2;
            $this->activity->save();

            return false;
        }

        if (($this->min > $this->bbWinPrice) && (!$this->bbWin)){
            $this->activity->status = 2;
            $this->activity->description = 'BB price is lower than min price. Reprice scipped';
            $this->activity->old_price = $this->currentPrice;
            $this->activity->bbWin = $this->bbWin;
            $this->activity->buybox_price = $this->bbWinPrice;
            $this->activity->min_price = $this->min;
            $this->activity->max_price = $this->max;
            $this->activity->save();

            $this->itemDB->next_schedule = Carbon::now()->addHour();
            $this->itemDB->save();

            return false;
        }


        if($this->repriceVerify()){
            $this->reprice();
            if($this->activity->new_price > $this->max){
                $this->activity->new_price = $this->max;
                $this->activity->description .= ' The item was repriced to MAX price.';
                $this->activity->status = 1;
                $this->activity->save();
            }
            if($this->activity->new_price < $this->min){
                $this->activity->new_price = $this->min;
                $this->activity->description .= ' The item was repriced to min price. ';
                $this->activity->save();
            }
            return $this->activity;
        } else {
            return false;
        }

        return $this->activity;
    }

    public function confirmReprice()
    {
        //dump('Confirm:', 'Activity: '. $this->activity->id, 'BBWIN: '. $this->bbWin, 'Current price: '. $this->currentPrice);

        if($this->bbWin){//BBWin
            $this->itemDB->current_price = $this->currentPrice;
            $this->itemDB->buy_box_won = $this->bbWin;
            $this->itemDB->next_schedule = Carbon::now()->addMinutes(30);

        } else { //BBLost
            if ($this->min > $this->bbWinPrice){ //BB lost and min price is higher than BB price
                $this->itemDB->next_schedule = Carbon::now()->addHour();
            } else {
                $this->itemDB->next_schedule = null;
            }
        }

        $this->itemDB->save();

        $this->getPrevHiAndLow();
        $this->getCurrentHiAndLow();
        $this->activity->bbWin = $this->bbWin;
        $this->activity->min_price = $this->min;
        $this->activity->max_price = $this->max;
        $this->activity->buybox_price = $this->bbWinPrice;
        $this->activity->high = $this->hi;
        $this->activity->low = $this->low;
        $this->activity->percent = $this->percent;
        $this->activity->abs = abs($this->abs);
        $this->activity->status = 1;
        $this->activity->save();

        return $this->activity;
    }

    /* Data Prepare */
    private function prepareData()
    {
        $this->itemDB = Item::find($this->activity->item_id);

        $this->min = $this->itemDB->min_price;
        $this->max = $this->itemDB->max_price;
        $this->bbWin = $this->getBBWin();
        $this->bbWinPrice = $this->scrappedProduct->priceInfo->currentPrice->price;
        $this->bbWinPrev = $this->getPrevBbWin();

        if($this->bbWin){
            $this->currentPrice = $this->scrappedProduct->priceInfo->currentPrice->price;
        } else {
            $this->currentPrice = $this->itemDB->current_price;
        }

        $this->percent = $this->getPercentDiff();
        //$this->getPrevHiAndLow();
        //$this->getCurrentHiAndLow();
    }

    private function getBBWin()
    {
        $walmartKeys = WalmartKey::find($this->itemDB->walmart_key_id);

        if($walmartKeys->seller_name == $this->scrappedProduct->sellerDisplayName){
            return 1;
        }

        return 0;
    }

    private function getPrevHiAndLow()
    {

        $prevActivity = ItemActivity::where('item_id', $this->activity->item_id)
                        ->where(function ($q) {
                            $q->where('status', 1)->
                                orWhere('status', 3);
                        })
                        ->orderBy('id', 'desc')
                        ->first();

        $this->prevHi = $prevActivity->high ?? -9999.12345678;
        $this->prevLow = $prevActivity->low ?? 9999.12345678;
    }

    private function getCurrentHiAndLow()
    {
        if($this->bbWin){
            if ($this->percent > $this->prevHi){
                $this->hi = $this->percent;
            } else {
                $this->hi = $this->prevHi;
            }

            $this->low = $this->prevLow;
        } else {
            if ($this->percent < $this->prevLow){
                $this->low = $this->percent;
            } else {
                $this->low = $this->prevLow;
            }

            $this->hi = $this->prevHi;
        }

        //dump('Hi = '.$this->hi, 'Prev Hi = '. $this->prevHi,'Low = '. $this->low, 'Low prev = '.$this->prevLow);

        if (($this->low != 9999.12345678) && ($this->hi != -9999.12345678)){
            $this->abs = abs($this->low - $this->hi);
        } else {
            $this->abs = null;
        }
    }

    private function getPrevBbWin()
    {
        $prevActivities = ItemActivity::where('item_id', $this->activity->item_id)
            ->where('status','1')
            ->where(function ($q) {
                $q->where('cancelled', null)->
                    orWhere('cancelled', false);
                })
            ->orderBy('id', 'desc')
            ->limit(3)
            ->get();

        if (count($prevActivities) > 1){
            $prevActivity = $prevActivities[0];
            return $prevActivity->bbWin;
        } else {
            return 0;
        }
    }

    public function toObject(mixed $data): mixed
    {
        if (!is_array($data)) {
            return $data;
        }

        if (array_is_list($data)) {
            return array_map([$this, 'toObject'], $data);
        }

        $object = new \StdClass();
        foreach ($data as $key => $value) {
            $object->$key = $this->toObject($value);
        }
        return $object;
    }

    private function getPercentDiff()
    {
        if ($this->bbWin){
            $diff = $this->bbWinPrice - $this->getSecondaryPrice();
        } else {
            $diff = $this->currentPrice - $this->bbWinPrice;
        }

        $percent = $diff / $this->bbWinPrice;

        return $percent;
    }

    private function getSecondaryPrice()
    {
        if ($this->scrappedProduct->secondaryOfferPrice){
            if ($this->scrappedProduct->secondaryOfferPrice->currentPrice){
                if($this->scrappedProduct->secondaryOfferPrice->currentPrice->price){
                    return $this->scrappedProduct->secondaryOfferPrice->currentPrice->price;
                }
                return 0;
            }
            return 0;
        }
        return 0;
    }
    /* End Of Data Prepare */

    /*=================================================================*/
    /* Logic */
    private function reprice()
    {
        $this->rule_1();


        $this->activity->old_price = $this->currentPrice;
        $this->activity->bbWin = $this->bbWin;
        $this->activity->min_price = $this->min;
        $this->activity->max_price = $this->max;
        $this->activity->buybox_price = $this->bbWinPrice;

        if (($this->newPrice >= $this->min) && ($this->newPrice <= $this->max)){
            $this->activity->new_price = $this->newPrice;
            $this->activity->description = $this->description . '= $'. $this->newPrice;
        } else {
            $this->activity->new_price = $this->currentPrice;
            $this->activity->description = 'The item was not repriced. The new price is out of min<=>Max range.';
            $this->cancelled = true;
        }

        $this->activity->description = $this->description;
        $this->activity->high = $this->hi;
        $this->activity->low = $this->low;
        $this->activity->percent = $this->percent;
        $this->activity->abs = abs($this->abs);
        $this->activity->status = 1;
        $this->activity->save();
    }

    private function repriceVerify()
    {
        if (($this->min == 0) || ($this->max == 0)) {
            $this->newPrice = $this->currentPrice;
            $this->status = 2;
            $this->description = 'The item was not repriced. MAX or min price was not set.';
            $this->cancelled = true;

            return false;
        }
        return true;
    }


    private function rule_1()
    {
        if ((!$this->competitionsCheck()) && ($this->bbWin)){ //no competitions going to MAX price rule 1.4
            $this->newPrice = $this->max;
            $this->status = 1;
            $this->description = 'The item was repriced to MAX price. No competitions. Next check in 6 hours.';
            $this->nextSchedule = Carbon::now()->addHours(6);
        } elseif ($this->competitionsCheck()) { //logic when has competitions
            if ($this->bbWin){
                if ($this->percent >= 0.2){
                    $this->newPrice = round($this->currentPrice + $this->currentPrice * 0.0025, 2);
                    $this->description = 'The item was repriced to currentPrice + 0.25%.';
                } elseif ($this->percent >= 0.1){
                    $this->newPrice = round($this->currentPrice + $this->currentPrice * 0.005, 2);
                    $this->description = 'The item was repriced to currentPrice + 0.5%.';
                } elseif ($this->percent >= 0.05){
                    $this->newPrice = round($this->currentPrice + $this->currentPrice * 0.005, 2);
                    $this->description = 'The item was repriced to currentPrice + 0.5%.';
                } elseif ($this->percent >= 0){
                    $this->newPrice = round($this->currentPrice + $this->currentPrice * 0.005, 2);
                    $this->description = 'The item was repriced to currentPrice + 0.5%.';
                } elseif ($this->percent >= -0.05){
                    $this->newPrice = round($this->currentPrice + $this->currentPrice * 0.01, 2);
                    $this->description = 'The item was repriced to currentPrice + 1%.';
                } elseif ($this->percent >= -0.1){
                    $this->newPrice = round($this->currentPrice + $this->currentPrice * 0.025, 2);
                    $this->description = 'The item was repriced to currentPrice + 2.5%.';
                } else{
                    $this->newPrice = round($this->currentPrice + $this->currentPrice * 0.05, 2);
                    $this->description = 'The item was repriced to currentPrice + 5%.';
                }
                $this->status = 1;
            } else {
                if(abs($this->percent) >= 0.2 ){
                    $this->newPrice = round($this->currentPrice * 0.9, 2);
                    $this->description = 'The item was repriced to currentPrice - 10%.';
                } elseif (abs($this->percent) >= 0.1 ){
                    $this->newPrice = round($this->currentPrice * 0.95, 2);
                    $this->description = 'The item was repriced to currentPrice - 5%.';
                } elseif (abs($this->percent) >= 0.05 ){
                    $this->newPrice = round($this->currentPrice * 0.97, 2);
                    $this->description = 'The item was repriced to currentPrice - 3%.';
                } else {
                    $this->newPrice = round($this->currentPrice * 0.99, 2);
                    $this->description = 'The item was repriced to currentPrice - 1%.';
                }
                $this->status = 1;
            }

            //dump($this->description, $this->percent, $this->newPrice);
        } else { //impossible situation when not competitions and not bbWin and BBlost


        }
    }

    private function competitionsCheck()
    {
        if ($this->scrappedProduct->secondaryOfferPrice){
            if ($this->scrappedProduct->secondaryOfferPrice->currentPrice){
                if($this->scrappedProduct->secondaryOfferPrice->currentPrice->price){
                    return true;
                }
                return false;
            }
            return false;
        }
        return false;
    }


    /* End Logic */
}
